function init() {
var back = document.getElementById("back");
back.style.display="none";
loadPrefs();
}


function loadPrefs() {
	var length = document.getElementById("passlength");
	var autocopy = document.getElementById("autocopy");
	var lowercase = document.getElementById("lwrcase");
	var uppercase = document.getElementById("uprcase");
	var numerals = document.getElementById("numrls");

	length.value = widget.preferenceForKey("length");
	autocopy.checked = widget.preferenceForKey("autocopy");
	lowercase.checked = widget.preferenceForKey("lowercase");
	uppercase.checked = widget.preferenceForKey("uppercase");
	numerals.checked = widget.preferenceForKey("numerals");
	autoCopy();
}



// Handles Create Button Rollover Status
function buttonover() {
var searchbutton = document.getElementById("createbutton");
searchbutton.src = "Images/CreateButtonOver.png";
}

function buttonidle() {
var searchbutton = document.getElementById("createbutton");
searchbutton.src = "Images/CreateButton.png";
}

function checklength() {
var length = document.getElementById("passlength").value;
if (length <= 0){
	document.getElementById("passlength").value = "1";
	}
}

// Generates Password
function random_text()
{
//defines character sets
var lowercase = "abcdefghijklmnopqrstuvwxyz";
var uppercase = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
var numerals = "0123456789";

//checks to see which checkboxes are selected
var lc = document.getElementById("lwrcase").checked;
var uc = document.getElementById("uprcase").checked;
var nu = document.getElementById("numrls").checked;

//defines the character string and adds together depending
//on which boxes have been checked

var characters="";

if (lc == 1) var characters = characters+lowercase;
if (uc == 1) var characters = characters+uppercase;
if (nu == 1) var characters = characters+numerals;

//checks the resulting string length
var length = characters.length;

if (length > 0) { 

//splits the string into array
var char_split = characters.split('');

// Create a random number with limits based on the number
// of possible random text strings

var pass='';
var x;
var y = document.getElementById('passlength').value;

for ( x = 1; x <= y; x++ ) {
var random_number = Math.floor(Math.random() * length);
pass = pass+char_split[random_number];
		}

var displaypass = pass;
document.getElementById("textbox").value = displaypass;
	
	} else {
	document.getElementById("textbox").value = "Select Input Characters";
	}
auto(pass);
}

function auto(pass) {
var pref = document.getElementById("autocopy");
if (pref.checked == true)
	widget.system('/bin/echo "'+[pass]+'" | /usr/bin/pbcopy', null);
savehistory(pass);
}

function savehistory(pass){
var history = document.getElementById("textbox");
history.results = pass;
}


// Apples Flip Button Script
var flipShown = false; 
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, 
firstElement:null, timer:null}; 


function mousemove (event) { 
    if (!flipShown) 
    { 
        if (animation.timer != null) 
        { 
            clearInterval (animation.timer); 
            animation.timer  = null; 
        } 
        var starttime = (new Date).getTime() - 13; 
        animation.duration = 500; 
        animation.starttime = starttime; 
        animation.firstElement = document.getElementById ('flip'); 
        animation.timer = setInterval ("animate();", 13); 
        animation.from = animation.now; 
        animation.to = 1.0; 
        animate(); 
        flipShown = true; 
    } 
} 
function mouseexit (event) { 
    if (flipShown) 
    { 
        // fade in the info button 
        if (animation.timer != null) 
        { 
            clearInterval (animation.timer); 
            animation.timer  = null; 
        } 
        var starttime = (new Date).getTime() - 13; 
        animation.duration = 500; 
        animation.starttime = starttime; 
        animation.firstElement = document.getElementById ('flip'); 
        animation.timer = setInterval ("animate();", 13); 
        animation.from = animation.now; 
        animation.to = 0.0; 
        animate(); 
        flipShown = false; 
    } 
} 

function animate() 
{ 
    var T; 
    var ease; 
    var time = (new Date).getTime(); 
    T = limit_3(time-animation.starttime, 0, animation.duration); 
    if (T >= animation.duration) 
    { 
        clearInterval (animation.timer); 
        animation.timer = null; 
        animation.now = animation.to; 
    } 
    else 
    { 
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration)); 
        animation.now = computeNextFloat (animation.from, animation.to, ease); 
    } 
    animation.firstElement.style.opacity = animation.now; 
} 
function limit_3 (a, b, c) 
{ 
    return a < b ? b : (a > c ? c : a); 
} 
function computeNextFloat (from, to, ease) 
{ 
    return from + (to - from) * ease; 
} 

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function showPrefs() 
{ 
    var front = document.getElementById("front"); 
    var back = document.getElementById("back");
    window.resizeTo(280,100);
    if (window.widget) 
        widget.prepareForTransition("ToBack"); 
    front.style.display="none"; 
    back.style.display="block"; 
    if (window.widget) 
        setTimeout ('widget.performTransition();', 0);
    checkVersion()
} 

function savePrefs() {
	var length = document.getElementById("passlength");
	var autocopy = document.getElementById("autocopy");
	var lowercase = document.getElementById("lwrcase");
	var uppercase = document.getElementById("uprcase");
	var numerals = document.getElementById("numrls");
	if(window.widget) {
		widget.setPreferenceForKey(length.value, "length");
		widget.setPreferenceForKey(autocopy.checked, "autocopy");
		widget.setPreferenceForKey(lowercase.checked, "lowercase");
		widget.setPreferenceForKey(uppercase.checked, "uppercase");
		widget.setPreferenceForKey(numerals.checked, "numerals");
	}
	hidePrefs();
}

function hidePrefs() 
{ 
    var front = document.getElementById("front"); 
    var back = document.getElementById("back"); 
    if (window.widget) 
        widget.prepareForTransition("ToFront"); 
    back.style.display="none"; 
    front.style.display="block"; 
    if (window.widget) 
        setTimeout ('widget.performTransition();', 0); 
    window.resizeTo(280,93);
} 

function checkVersion() {
document.getElementById("version").style.display = "block";
}





